% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bma_design.R
\name{bma_design}
\alias{bma_design}
\title{Simulate a BMA design}
\usage{
bma_design(
  nSims,
  nBaskets,
  maxDistinct = nBaskets,
  eRates,
  rRates,
  meanTime,
  sdTime,
  ppEffCrit,
  ppFutCrit,
  futOnly = FALSE,
  rRatesNull,
  rRatesAlt,
  minSSFut,
  minSSEff,
  minSSEnr,
  maxSSEnr,
  targSSPer,
  I0,
  mu0 = 0.5,
  phi0 = 1,
  priorModelProbs = NULL,
  pmp0 = 1
)
}
\arguments{
\item{nSims}{number of simulation studies to be performed}

\item{nBaskets}{number of baskets}

\item{maxDistinct}{integer between 1 and \code{nBaskets} giving number of distinct model probabilities to use. Defaults to \code{nBaskets}. It is recommended to call \code{\link{numModels}} to ensure that computation is tractable.}

\item{eRates}{scalar or vector of Poisson process rates for each basket}

\item{rRates}{scalar or vector of true response rates for each basket}

\item{meanTime}{mean parameter for time to outcome ascertainment}

\item{sdTime}{standard deviation parameter for time to outcome ascertainment}

\item{ppEffCrit}{scalar or vector giving basket-specific posterior probability threshold for activity (i.e., efficacy).}

\item{ppFutCrit}{scalar or vector giving basket-specific posterior probability threshold for futility}

\item{futOnly}{\code{logical} giving whether design allows only for futility stopping (\code{TRUE} = futility only, \code{FALSE} = both futility and efficacy)}

\item{rRatesNull}{scalar or vector of basket-specific null hypothesis values (for efficacy determination)}

\item{rRatesAlt}{scalar or vector of basket-specific hypothesized alternative values (for futility determination)}

\item{minSSFut}{minimum number of subjects in basket to assess futility}

\item{minSSEff}{minimum number of subjects in basket to assess activity}

\item{minSSEnr}{matrix giving minimum number of new subjects per basket before next analysis (each row is an interim analysis, each column is a basket)}

\item{maxSSEnr}{matrix giving maximum number of new subjects per basket before next analysis (each row is an interim analysis, each column is a basket)}

\item{targSSPer}{scalar or vector giving target sample size increment for each basket}

\item{I0}{maximum number of analyses}

\item{mu0}{prior mean for the response probabilities}

\item{phi0}{prior dispersion response probabilities}

\item{priorModelProbs}{vector giving prior probabilities for models. Default is prior of each model is proportional \code{exp(pmp0 * D)} where \code{D} is the number of distinct parameters in the model}

\item{pmp0}{scalar giving power for \code{priorModelProbs}. If \code{pmp0==0}, a uniform prior is used for model probabilities. Defaults to 1. Ignored if \code{priorModelProbs} is not \code{NULL}}
}
\value{
a nested list giving results of the simulation with the following structure:
\itemize{
\item \strong{hypothesis.testing}       - hypothesis testing information
\itemize{
\item \strong{rr}                     - basket-specific null hypothesis rejection rate
\item \strong{fw.fpr}                 - family-wise false positive rate (across all inactive baskets)
\item \strong{nerr}                   - average number of false null hypothesis rejections
\item \strong{fut}                    - basket-specific probability of futility stopping
}
\item \strong{sample.size}              - trial sample size information
\itemize{
\item \strong{basket.ave}             - basket-specific expected sample size
\item \strong{basket.med}             - basket-specific median sample size
\item \strong{basket.min}             - basket-specific minimum sample size
\item \strong{basket.max}             - basket-specific maximum sample size
\item \strong{overall.ave}            - expected overall sample size
}
\item \strong{point.estimation}         - point estimation information
\itemize{
\item \strong{PM.ave}                 - basket-specific average posterior mean
\item \strong{SP.ave}                 - basket-specific average sample proportion
\item \strong{PP.ave}                 - basket-specific average posterior probability
\item \strong{bias}                   - basket-specific bias of the posterior mean
\item \strong{mse}                    - basket-specific MSE of the posterior mean
}
\item \strong{early.stopping}           - early stopping information
\itemize{
\item \strong{interim.stop.prob}      - probability of trial stoppage by interim
\item \strong{baskets.continuing.ave} - average number of baskets continuing past interim
}
}
}
\description{
Simulates a BMA design given hyperparameters
}
\examples{
## SIMULATE DATA AND SET SIMULATION PARAMS
nSims      <- 100             ## would be much more in practice                     
meanTime   <- 0.01
sdTime     <- 0.0000000001
mu0        <- 0.45
phi0       <- 1.00
ppEffCrit  <- 0.985
ppFutCrit  <- 0.2750
pmp0       <- 2
n1         <- 7
n2         <- 16
targSSPer  <- c(n1, n2)
nInterim   <- 2
futOnly    <- 1
K0         <- 5
row        <- 0
mss        <- 4
minSSFut   <- mss  ## minimum number of subjects in basket to assess futility using BMA
minSSEff   <- mss  ## minimum number of subjects in basket to assess activity using BMA
rTarg      <- 0.45
rNull      <- 0.15
rRatesMod  <- matrix(rNull,(K0+1)+3,K0)
rRatesNull <- rep(rNull,K0)
rRatesMid  <- rep(rTarg,K0)
eRatesMod  <- rep(1, K0)

## min and max #' of new subjects per basket before next analysis (each row is interim)
minSSEnr <- matrix(rep(mss, K0), nrow=nInterim ,ncol=K0, byrow=TRUE) 
maxSSEnr <- matrix(rep(100, K0), nrow=nInterim, ncol=K0, byrow=TRUE) 

## construct matrix of rates
for (i in 1:K0)  
{
  rRatesMod[(i+1):(K0+1),i]= rTarg     
}
rRatesMod[(K0+2),] <- c(0.05,0.15,0.25,0.35,0.45)
rRatesMod[(K0+3),] <- c(0.15,0.30,0.30,0.30,0.45)
rRatesMod[(K0+4),] <- c(0.15,0.15,0.30,0.30,0.30)

## conduct simulation of trial data and analysis
x <- bma_design(
  nSims, K0, K0, eRatesMod, rRatesMod[i+1,], meanTime, sdTime, 
  ppEffCrit, ppFutCrit, as.logical(futOnly), rRatesNull, rRatesMid, 
  minSSFut, minSSEff, minSSEnr, maxSSEnr, targSSPer, nInterim, mu0, 
  phi0, priorModelProbs = NULL, pmp0 = pmp0
)
}
