% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_opt.R
\name{find_opt}
\alias{find_opt}
\title{Find optimal number of fourier variables}
\usage{
find_opt(
  x,
  dates,
  H = NULL,
  AO = NULL,
  method = "additive",
  l.max = 24,
  k.max = 42,
  by = 6
)
}
\arguments{
\item{x}{Numeric vector. Time series to seasonally adjust}

\item{dates}{a vector of class "Date", containing the data dates}

\item{H}{(optional) Matrix with holiday and trading day variables}

\item{AO}{(optional) Matrix with additive outlier variables}

\item{method}{Decomposition method: "additive" or "multiplicative". By default uses the additive method}

\item{l.max}{maximal number of the monthly cycle variables to search for}

\item{k.max}{maximal number of the yearly cycle variables to search for}

\item{by}{step size in the search}
}
\value{
list with the optimal number of (yearly and monthly) fourier variables according to AIC, AICc and BIC
}
\description{
Searches through the model space to identify the best number of trigonometric variables, with the lowest AIC, AICc or BIC value.
}
\examples{

data(gasoline.data)

res=find_opt(x=gasoline.data$y,dates=gasoline.data$date)
print(res)

}
