#' McVeigh et al. (2014) Tea Party Data
#'
#' This data set is an abbreviated version of the data set used by McVeigh et al. (2014). These data cover all 67 counties in Florida, and come from the American Community Survey (2005-2009).
#'
#' @format A data frame with 67 observations and 13 variables.
#' \tabular{ll}{ \cr
#'  tprallies \tab number of Tea Party rallies in county, 2009-2010 \cr
#'  reppct2008 \tab percent of county vote for the Republican Presidential candidate (John McCain) in 2008 \cr
#'  dempct2008 \tab percent of county vote for the Democratic Presidential candidate (Barack Obama) in 2008 \cr
#'  pctBA25 \tab percent of county, aged 25 or older, with a bachelor's degree \cr
#'  pctunemp \tab percent of county that is unemployed \cr
#'  pctevang \tab percent of county that belongs to an Evangelical denomination \cr
#'  pctblack \tab percent of county that identifies as Black \cr
#'	P \tab binary. \code{0} if county had no Tea Party rallies, \code{1} if county had \emph{at least} on Tea Party rally \cr
#'	R \tab binary. \code{0} if the majority of votes in the county were for the Democratic Presidential candidate (Barack Obama) in 2008, \code{1} if the majority of votes in the county were for the Republican Presidential candidate (John McCain) in 2008\cr
#'	C \tab binary. \code{0} if percent of county with a bachelor's degree was below-average for Florida, \code{1} if percent of county with a bachelor's degree was at or above-average for Florida \cr
#'	U \tab binary. \code{0} if percent unemployed in county was below-average for Florida, \code{1} if percent unemployed in county was at or above-average for Florida \cr
#'	E \tab binary. \code{0} if percent Evangelical in county was below-average for Florida, \code{1} if percent Evangelical in county was at or above-average for Florida \cr
#'	B \tab binary. \code{0} if percent Black in county was below-average for Florida, \code{1} if percent Black in county was at or above-average for Florida \cr
#' }

#'
"rallies"
