\name{potentiationPlot}
\alias{potentiationPlot}
\title{
Plot Potentiation in a BRAID Fitted Combination
}
\description{
Generates a \code{ggplot2} plot object depicting the potentiaton or curve-shift of one compound
by the presence of another, based on BRAID surface fit generated by the 'braidrm' package.
}
\usage{
potentiationPlot(bfit, levs, dnum = 1, concs = NULL, control = list())
}
\arguments{
  \item{bfit}{ an object of class 'braidrm' representing a BRAID surface fit }
  \item{levs}{ a vector of levels of the "potentiating" drug to be plotted }
  \item{dnum}{ index of the drug to be plotted on the x-axis (the "potentiated" drug). Default
value 1 }
  \item{concs}{ an optional parameter specifying the concentrations of the "potentiated" drug to be
plotted. If \code{NULL} (the default), a length-100 vector of evenly spaced concentrations will be
plotted covering the range of concentrations in all combinations in which both drugs are non-zero. }
  \item{control}{ A list of optional control parameters adjusting the appearance of the plot. See
Details for a full description }
}
\details{
This function is less basic than the response mapping function \code{\link{responseMap}}, and is
intended as a convenience for those who wish to visualize potentiation in a BRAID-fit surface. Many
details of the plot are adjusted by the \code{control} parameter, which may contain any or all of
the following elements:
\describe{
  \item{xlog}{ a boolean variable reflecting whether the concentration plotted on the x-axis (the
"potentiated" drug) should be plotted on a logarithmic scale. Default value is \code{TRUE} }
  \item{ylog}{ a boolean variable reflecting whether the concentration plotted on the x-axis (the
modelled effect) should be plotted on a logarithmic scale. Default value is \code{FALSE} }
  \item{addscales}{ a boolean that controls whether logarithmic scales will be explicitly added to
the resulting plot.  \code{ggplot2} prefers that only one scale be added to a given aesthetic, and
throws a warning otherwise, so those who wish to plot the x- or y-variables logarithmically, but
wish to add their own \code{ggplot2} scales (to control axis limits, labels, etc.) should set this
parameter to \code{FALSE}. Default value is \code{TRUE} }
  \item{xtrans}{ an optional function mapping the concentration of the potentiated drug to the
transformed value that the user wishes to plot.  A simple example would be one in which the fit was
performed on concentrations expressed in molar, but the user wishes to plot the concentrations in
micromolar, in which case the value of 'xtrans' might be \code{function(x) x*10^6}. }
  \item{ytrans}{ an optional function mapping the modelled effect to the transformed value that the
user wishes to plot.  An example might be a case in which the modelled effect variable is a
logarithmic transform of a real-world measurement, and the user wishes to plot the measured value,
in which case the value of 'ytrans' might be \code{function(y) 10^y}. }
  \item{thresh}{ an optional value (or vector of values) of the modeled effect that will be plotted
as a dotted horizontal line. Used to visualize where the shifted dose-response curves cross a
desired threshold or thresholds.  Note that if \code{ytrans} is specified, the values in
\code{thresh} should be desired thresholds \emph{prior} to transformation. }
  \item{ciplot}{ a boolean variable reflecting whether 95\% confidence intervals will be plotted
around the potentiated DR curves.  If the 'braidrm' object \code{bfit} does not possess valid
confidence intervals, then this parameter automatically is set to \code{FALSE}; if it has been
explicitly set to \code{TRUE}, a warning will be printed indicating that confidence intervals
cannot be plotted.  Default value is \code{TRUE} }
  \item{cialpha}{ a boolean variable controlling how the confidence intervals are plotted. By
default, confidence intervals are plotted as filled ribbons (using \code{\link{geom_ribbon}}) with
an alpha (opacity) value of 0.3.  This allows the confidence ranges to overlap, and use the same
color scale as the plotted curves while remaining visually distinguishable.  Unfortunately, some
graphics outputs (including EPS) do not support transparency.  Setting this parameter to FALSE will
plot the confidence intervals with full opacity; the user may distinguish them from the DR curves
by using a different color scale for the 'colour' and 'fill' aesthetics.  Default value is
\code{TRUE} }
  \item{pts}{ a boolean variable determining whether points are plotted along the potentiated DR
curves.  If true, each DR curve will have points plotted at all unique concentrations of the
potentiated drug (in the plotted range) which appeared in any combination in the fitted data in
which both drugs had non-zero concentrations.  Note, however, that this does not plot actual
measured effect, as there no guarantee that the levels of the potentating drug which are plotted
were tested in the original experiment.  Plotting these points simply offers a way to visualize
which concentrations of the potentiated drug were actually measured experimentally.  Default value
is \code{FALSE} }
  \item{ptsize}{ an optional size parameter passed to \code{\link{geom_point}} to control the size
of plotted points.  If \code{pts} is omitted or set to \code{FALSE} this parameter is ignored. }
  \item{pconcs}{ if desired, the user may set this control parameter to explicitly determine which
concentrations of the potentiated drug will be plotted as points.  This is used in
\code{\link{makeBRAIDreport}} when concentration corrections have altered the concentrations fed
into the BRAID fitting model. }
  \item{lnsize}{ an optional size parameter passed to \code{\link{geom_line}} and, if \code{thresh}
is included, \code{\link{geom_hline}} to control the size of plotted lines. }
}
Though this function is intended to much of the heavy lifting in plotting potentiation (especially
as applied to confidence intervals), many choices are left to the user.  Axis labels are not
applied, and scales are not applied to the 'colour' or 'fill' aesthetics.  Users may also, of
use any \code{ggplot2} theme functions to further adjust the appearance of the plot.
}
\value{
A \code{ggplot2} plot object, depicting the dose-response curves of the potentiated drug in the
presence of various levels of the potentiating drug.
}
\references{
Twarog, N.R., Stewart, E., Vowell Hamill, C., and Shelat, A.  BRAID: A Unifying Paradigm for the 
Analysis of Combined Drug Action. \emph{Scientific Reports} \strong{In Press} (2016).
}
\author{
Nathaniel R. Twarog
}
\seealso{
\code{\link{makeBRAIDreport}}
}
\examples{
data(es8analysis)
bfit <- es8analysis$braidFit
pcont <- list(xtrans=function(x) x*10^6,ytrans=function(y) 10^y,ylog=TRUE,thresh=-1)
potentiationPlot(bfit,c(0,10^-6,10^-5,10^-4),control=pcont)
}
\keyword{ hplot }
