% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_global.R
\name{brainGraph_boot}
\alias{brainGraph_boot}
\alias{summary.brainGraph_boot}
\title{Bootstrapping for global graph measures}
\usage{
brainGraph_boot(densities, resids, R = 1000, measure = c("mod", "E.global",
  "Cp", "Lp", "assortativity", "strength", "mod.wt", "E.global.wt"),
  conf = 0.95, .progress = TRUE)

\method{summary}{brainGraph_boot}(object, ...)
}
\arguments{
\item{densities}{Numeric vector of graph densities to loop through}

\item{resids}{An object of class \code{brainGraph_resids} (the output from
\code{\link{get.resid}})}

\item{R}{Integer; the number of bootstrap replicates (default: \code{1e3})}

\item{measure}{Character string of the measure to test (default: \code{mod})}

\item{conf}{Numeric; the confidence level for calculating confidence
intervals (default: 0.95)}

\item{.progress}{Logical indicating whether or not to show a progress bar
(default: \code{TRUE})}

\item{object}{A \code{brainGraph_boot} object (from
\code{\link{brainGraph_boot}})}

\item{...}{Unused}
}
\value{
An object of class \code{brainGraph_boot} containing some input
  variables, in addition to a list of \code{\link[boot]{boot}} objects (one
  for each group).
}
\description{
Performs bootstrapping to get group standard error estimates of a global
graph measure (e.g. modularity).

Print a summary from a bootstrap analysis
}
\details{
The confidence intervals are calculated using the normal approximation and at
the 95\% level.
}
\examples{
\dontrun{
boot.E.global <- brainGraph_boot(densities, resids.all, 1e3, 'E.global')
}
}
\seealso{
\code{\link[boot]{boot}}

Other Group analysis functions: \code{\link{IndividualContributions}},
  \code{\link{NBS}}, \code{\link{brainGraph_GLM}},
  \code{\link{brainGraph_mediate}},
  \code{\link{brainGraph_permute}}, \code{\link{mtpc}}

Other Structural covariance network functions: \code{\link{IndividualContributions}},
  \code{\link{brainGraph_init}},
  \code{\link{brainGraph_permute}},
  \code{\link{corr.matrix}}, \code{\link{get.resid}},
  \code{\link{plot.brainGraph_resids}},
  \code{\link{plot_volumetric}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
