% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_brmap.R
\name{plot_brmap}
\alias{plot_brmap}
\title{Facilitated plot of brazilian maps}
\usage{
plot_brmap(map, data_to_join = data.frame(), join_by = NULL,
  var = "values", theme = theme_map())
}
\arguments{
\item{map}{An object of class 'sf', 'SpatialPolygonsDataFrame' or 'data.frame'}

\item{data_to_join}{A data frame containing values to plot on the map.}

\item{join_by}{A character vector of variables to join by.}

\item{var}{The name of the column that contains the values of the field to
be plotted. The default is \code{"value"}.}

\item{theme}{The theme that should be used for plotting the map. The default
is \code{\link[ggthemes]{theme_map}}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object that contains a basic
  brazilian map with the described parameters. Since the result is a \code{ggplot}
  object, it can be extended with more \code{geom} layers, scales, labels,
  themes, etc.
}
\description{
A wrapper in order to facilitate the plot
of the maps from this package. The function
returns a ggplot object so it can be edited
easily.
}
\examples{
## Plotting population estimates (2017) of the South Region
data("pop2017")
map_sul <- get_brmap(geo = "City", geo.filter = list(Region = 4))
mapa1 <- plot_brmap(map_sul,
                    data_to_join = pop2017,
                    join_by = c("City" = "mun"),
                    var = "pop2017")
mapa1

# Output is ggplot object so it can be extended
# with any number of ggplot layers
library(ggplot2)
mapa1 +
  labs(title = "População Municipal 2017 - Região Sul")


# Only displaying the microregions of the state of Sao Paulo
map_sp_micro <- get_brmap(geo = "MicroRegion",
                          geo.filter = list(State = 35),
                          class = "SpatialPolygonsDataFrame")
plot_brmap(map_sp_micro)

}
\seealso{
\code{\link{get_brmap}}, \code{\link[ggplot2]{theme}}
}
