% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/richness_objective_bayes.R
\name{objective_bayes_mixedgeo}
\alias{objective_bayes_mixedgeo}
\title{Objective Bayes species richness estimate with the mixed-geometric model}
\usage{
objective_bayes_mixedgeo(
  data,
  output = TRUE,
  plot = TRUE,
  answers = FALSE,
  tau = 10,
  burn.in = 100,
  iterations = 2500,
  Metropolis.stdev.N = 100,
  Metropolis.start.T1 = 1,
  Metropolis.stdev.T1 = 2,
  Metropolis.start.T2 = 3,
  Metropolis.stdev.T2 = 2
)
}
\arguments{
\item{data}{A frequency count table}

\item{output}{Print summary of fitted model. Default is TRUE.}

\item{plot}{Plot estimates? Default is TRUE.}

\item{answers}{Return dataframe containing model summaries? Default is FALSE.}

\item{tau}{Truncation cutoff for model fitting. (Counts above this cutoff
are not used in model fitting.) Default is 10.}

\item{burn.in}{Number of MCMC burn-in iterations. Default is 1000.}

\item{iterations}{Number of MCMC iterations after burn-in. Default is 5000.}

\item{Metropolis.stdev.N}{Standard deviation of proposal distribution
parameter N within MCMC. Default is 100.}

\item{Metropolis.start.T1}{Starting value of parameter T1. Default is 1.}

\item{Metropolis.stdev.T1}{Standard deviation of proposal distribution
parameter T1 within MCMC. Default is 2.}

\item{Metropolis.start.T2}{Starting value of parameter T2. Default is 3.}

\item{Metropolis.stdev.T2}{Standard deviation of proposal distribution
parameter T2 within MCMC. Default is 2.}
}
\value{
If answers set to TRUE, a list containing posterior median and
95\% posterior credible intervals for richness, fitted values, and
MCMC diagnostics. If answers set to FALSE (default), no value is returned.
}
\description{
Objective Bayes species richness estimate with the mixed-geometric model
}
