% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bricks-from-tables.R
\name{bricks_from_excel}
\alias{bricks_from_excel}
\title{Convert an Excel 'brickr' template into a 3D object}
\usage{
bricks_from_excel(
  excel_table,
  piece_table = NULL,
  use_bricks = NULL,
  repeat_levels = 1,
  increment_level = 0,
  min_level = 1,
  max_level = Inf,
  increment_x = 0,
  max_x = Inf,
  increment_y = 0,
  max_y = Inf,
  exclude_color = NULL,
  exclude_level = NULL
)
}
\arguments{
\item{excel_table}{Sheet imported from a brickr Excel template to build model.
This differs slightly from \code{\link{bricks_from_table}} because a single data frame has both the brick coordinates and color table.}

\item{piece_table}{Sheet identical in shape to \code{excel_table} with piece shape IDs.}

\item{use_bricks}{Array of brick sizes to use in mosaic. Defaults to \code{c('4x2', '3x2', '2x2', '3x1', '2x1', '1x1')}`.}

\item{repeat_levels}{How many times to repeat a level. Can save time in model planning. Default is 1.}

\item{increment_level}{Default '0'. Use in animations. Shift  Level/z dimension by an integer.}

\item{min_level}{Default '1'. Use in animations. Any Level/z values below this value will be cut off.}

\item{max_level}{Default 'Inf'. Use in animations. Any Level/z values above this value will be cut off.}

\item{increment_x}{Default '0'. Use in animations. Shift x dimension by an integer.}

\item{max_x}{Default 'Inf'. Use in animations. Any x values above this value will be cut off.}

\item{increment_y}{Default '0'. Use in animations. Shift y dimension by an integer.}

\item{max_y}{Default 'Inf'. Use in animations. Any y values above this value will be cut off.}

\item{exclude_color}{Numeric array of color ID numbers to exclude.}

\item{exclude_level}{Numeric array of Level/z dimensions to exclude.}
}
\value{
A list with elements \code{Img_lego} to pass to \code{\link{build_bricks}}.
}
\description{
Build a 3D model from an Excel template. A single data frame includes both the instructions and the color guides.
}
\examples{
#Demo table in same format as Excel template
#This creates a 1x3 red brick.
demo_excel <- tibble::tribble(
~Level, ~"1", ~"2", ~"3", ~user_color, ~LEGO_color,
 "A",  1,  1,  1,           1, "Bright red" 
)

demo_excel \%>\% 
 bricks_from_excel() \%>\% 
 build_bricks()
 
 rgl::clear3d()
 
#To change the pieces, import a second table in the same shape, but with piece IDs.
demo_pieces <- tibble::tribble(
~Level, ~"1", ~"2", ~"3",
 "A",  "w4",  "c1",  "w2"    
)

demo_excel \%>\% 
 bricks_from_excel(piece_table = demo_pieces) \%>\% 
 build_bricks()
 
 rgl::clear3d()
 
}
\seealso{
Other 3D Models: 
\code{\link{bricks_from_coords}()},
\code{\link{bricks_from_mosaic}()},
\code{\link{bricks_from_table}()},
\code{\link{build_bricks}()}
}
\concept{3D Models}
