% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors-and-themes.R
\name{build_colors}
\alias{build_colors}
\title{Display available brick colors}
\usage{
build_colors(.names_only = FALSE, include_transparent = TRUE)
}
\arguments{
\item{.names_only}{Return an array of the 41 solid brick color names and 13 transparent colors. Does not plot.}

\item{include_transparent}{Include transparent colors in the plot output.}
}
\value{
An array or ggplot of brick colors & ID numbers.
}
\description{
Generates a plot of available brick colors. These names must be used exactly when creating custom name lists.
There are 41 solid brick color names and 13 transparent colors. Transparent colors are not used in mosaics.
}
\details{
Use .names_only = TRUE to get a list of color names.
}
\examples{
#Generate plot of colors
build_colors(include_transparent = FALSE)

#Print list of colors
build_colors(TRUE)
}
\seealso{
Other Resources: 
\code{\link{build_instructions}()},
\code{\link{build_pieces_table}()},
\code{\link{build_pieces}()}
}
\concept{Resources}
