% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{fixef.brmsfit}
\alias{fixef}
\alias{fixef.brmsfit}
\title{Extract Population-Level Estimates}
\usage{
\method{fixef}{brmsfit}(object, estimate = "mean", ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}}

\item{estimate}{A character vector specifying which coefficients 
(e.g., \code{"mean"}, \code{"median"}, \code{"sd"}, or \code{"quantile"})
should be calculated for the population-level effects.}

\item{...}{Further arguments to be passed to the functions 
specified in \code{estimate}}
}
\value{
A matrix with one row per population-level effect 
  and one column per calculated estimate.
}
\description{
Extract the population-level ('fixed') effects 
from a \code{brmsfit} object.
}
\examples{
\dontrun{
fit <- brm(time | cens(censored) ~ age + sex + disease, 
           data = kidney, family = "exponential")
fixef(fit, estimate = c("mean", "sd"))
}

}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}

