% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{fixef.brmsfit}
\alias{fixef.brmsfit}
\alias{fixef}
\title{Extract Population-Level Estimates}
\usage{
\method{fixef}{brmsfit}(object, summary = TRUE, robust = FALSE,
  probs = c(0.025, 0.975), pars = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{summary}{Should summary statistics 
 (i.e. means, sds, and 95\% intervals) be returned
instead of the raw values? Default is \code{TRUE}.}

\item{robust}{If \code{FALSE} (the default) the mean is used as 
the measure of central tendency and the standard deviation as 
the measure of variability. If \code{TRUE}, the median and the 
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile} 
function. Only used if \code{summary} is \code{TRUE}.}

\item{pars}{Optional names of coefficients to extract.
By default, all coefficients are extracted.}

\item{...}{Currently ignored.}
}
\value{
If \code{summary} is \code{TRUE}, a matrix with one row per 
  population-level effect and one column per calculated estimate. 
  If \code{summary} is \code{FALSE}, a matrix with one row per 
  posterior sample and one column per population-level effect.
}
\description{
Extract the population-level ('fixed') effects 
from a \code{brmsfit} object.
}
\examples{
\dontrun{
fit <- brm(time | cens(censored) ~ age + sex + disease, 
           data = kidney, family = "exponential")
fixef(fit)
# extract only some coefficients
fixef(fit, pars = c("age", "sex"))
}

}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
