% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/qr.R
\name{qr2}
\alias{qr2}
\title{The QR decomposition of a matrix}
\usage{
qr2(x, tol = 0.0000001)
}
\arguments{
\item{x}{A matrix whose QR decomposition is to be computed.}

\item{tol}{The tolerance for detecting linear dependencies in the
  columns of \code{x}.}
}
\value{
A list of two matrices: Q and R.
}
\description{
Computes the QR decomposition of a matrix.
}
\details{
Calls the function \code{\link[base]{qr}} and returns
  less compact but more understandable output.
}
\examples{
hilbert <- function(n) { i <- 1:n; 1/outer(i-1,i,"+") }
h5 <- hilbert(5);
qr2(h5)
}
\seealso{
\code{\link[base]{qr}}
}
\keyword{algebra}

