% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciplot.R
\name{ciplot}
\alias{ciplot}
\title{Effect plot with multiple CIs for different groups}
\usage{
ciplot(est, se = NULL, lo = NULL, hi = NULL, SEmult = 2,
  labels = NULL, rotate = FALSE, ...)
}
\arguments{
\item{est}{Vector of estimates}

\item{se}{Vector of standard errors}

\item{lo}{Vector of lower values for the intervals}

\item{hi}{Vector of upper values for the intervals}

\item{SEmult}{SE multiplier to create intervals}

\item{labels}{Labels for the groups (vector of character strings)}

\item{rotate}{If TRUE, have group as y-axis; default (FALSE) has
group on x-axis.}

\item{...}{Optional graphics arguments}
}
\value{
None.
}
\description{
Uses \code{\link[=grayplot]{grayplot()}} to plot a set of confidence intervals.
}
\details{
Calls \code{\link[=grayplot]{grayplot()}} with special choices of
graphics parameters, as in \code{\link[=dotplot]{dotplot()}}.

Provide either \code{se} or both \code{lo} and \code{hi}. In the case that \code{se} is
used, the intervals will be \code{est} +/- \code{SEmult * se}.

If \code{labels} is not provided, group names are taken from the \code{names(est)}.
If that is also missing, we use capital letters.

You can control the CI line widths with \code{ci_lwd} and the color of
the CI segments with \code{ci_col}. You can control the width of the
segments at the top and bottom with \code{ci_endseg}.
}
\examples{
\dontshow{set.seed(97536917)}
x <- rnorm(40, c(1,3))
g <- rep(c("A", "B"), 20)
me <- tapply(x, g, mean)
se <- tapply(x, g, function(a) sd(a)/sqrt(sum(!is.na(a))))
ciplot(me, se) # default is +/- 2 SE
ciplot(me, se, SEmult=1)
ciplot(me, se, rotate=TRUE)
lo <- me - 2*se
hi <- me + 2*se
ciplot(me, lo=lo, hi=hi)

}
\seealso{
\code{\link[=grayplot]{grayplot()}}, \code{\link[=dotplot]{dotplot()}}
}
\keyword{graphics}
