% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisher.R
\name{fisher}
\alias{fisher}
\title{Fisher's exact test for a two-way table}
\usage{
fisher(tab, n.sim = 1000)
}
\arguments{
\item{tab}{A matrix of counts.}

\item{n.sim}{Number of samples of permuted tables to consider.}
}
\value{
A single number: the P-value testing independence of rows and columns
in the table.
}
\description{
Performs a sampling version of Fisher's exact test for a two-way
contingency table.
}
\details{
This is like the function \code{\link[stats:fisher.test]{stats::fisher.test()}}, but
calculates an approximate P-value rather than performing a complete
enumeration.  This will be better for large, sparse tables.
}
\examples{
TeaTasting <- matrix(c(3,1,1,3),nrow=2)
fisher(TeaTasting,1000)

}
\seealso{
\code{\link[stats:chisq.test]{stats::chisq.test()}}, \code{\link[stats:fisher.test]{stats::fisher.test()}}, \code{\link[=chisq]{chisq()}}
}
\keyword{htest}
