% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_tidiers.R
\name{tidy_margins}
\alias{tidy_margins}
\title{Average Marginal Effects with \code{margins::margins()}}
\usage{
tidy_margins(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{(a model object, e.g. \code{glm})\cr
A model to be tidied.}

\item{conf.int}{(\code{logical})\cr
Whether or not to include a confidence interval in the tidied output.}

\item{conf.level}{(\code{numeric})\cr
The confidence level to use for the confidence interval (between \code{0} ans \code{1}).}

\item{...}{Additional parameters passed to \code{margins::margins()}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}
}
\details{
The \code{margins} package is no longer under active development and may be
removed from CRAN sooner or later. It is advised to use the \code{marginaleffects}
package instead, offering more functionalities. You could have a look at the
\href{https://larmarange.github.io/broom.helpers/articles/marginal_tidiers.html}{article}
dedicated to marginal estimates with \code{broom.helpers}. \code{tidy_avg_slopes()}
could be used as an alternative.

Use \code{margins::margins()} to estimate average marginal effects (AME) and
return a tibble tidied in a way that it could be used by \code{broom.helpers}
functions. See \code{margins::margins()} for a list of supported models.

By default, \code{margins::margins()} estimate average marginal effects (AME): an
effect is computed for each observed value in the original dataset before
being averaged.

For more information, see \code{vignette("marginal_tidiers", "broom.helpers")}.
}
\note{
When applying \code{margins::margins()}, custom contrasts are ignored.
Treatment contrasts (\code{stats::contr.treatment()}) are applied to all
categorical variables. Interactions are also ignored.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
df <- Titanic |>
  dplyr::as_tibble() |>
  tidyr::uncount(n) |>
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes")))
mod <- glm(
  Survived ~ Class + Age + Sex,
  data = df, family = binomial
)
tidy_margins(mod)
tidy_plus_plus(mod, tidy_fun = tidy_margins)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{margins::margins()}

Other marginal_tieders: 
\code{\link{tidy_all_effects}()},
\code{\link{tidy_avg_comparisons}()},
\code{\link{tidy_avg_slopes}()},
\code{\link{tidy_ggpredict}()},
\code{\link{tidy_marginal_contrasts}()},
\code{\link{tidy_marginal_predictions}()}
}
\concept{marginal_tieders}
