% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/brr.R
\name{inference.brr}
\alias{coef.brr}
\alias{confint.brr}
\alias{inference.brr}
\alias{predict.brr}
\alias{print.coef.brr}
\alias{print.confint.brr}
\alias{print.predict.brr}
\title{Credibility intervals and estimates}
\usage{
\method{confint}{brr}(object, parm = NULL, level = 0.95,
  intervals = "all", ...)

\method{print}{confint.brr}(x, style = "grid", ...)

\method{coef}{brr}(object, parameter = "phi", ...)

\method{print}{coef.brr}(x, ...)

\method{predict}{brr}(object, level = 0.95, ...)

\method{print}{predict.brr}(x, style = "grid", ...)
}
\arguments{
\item{object}{a \code{\link[=Brr]{brr}} object}

\item{parm}{ignored}

\item{level}{confidence level}

\item{intervals}{a character vector, the intervals to be returned}

\item{...}{other aguments passed to \code{\link{brr_intervals}} or \code{\link{brr_estimates}}}

\item{x}{the output to be printed}

\item{style}{the style of the table to print
(passed to  \code{\link[=pander]{pandoc.table.return}})}

\item{parameter}{parameter of interest \code{"phi"} or \code{"VE"} (\code{=1-phi})}
}
\value{
\code{confint.brr} returns a list of confidence intervals,
\code{coef.brr} returns a list of estimates,
\code{predict.brr} returns a data frame.
}
\description{
Get credibility intervals and estimates from a \code{brr} object






}
\details{
\code{confint.brr} is a wrapper to \code{\link{brr_intervals}} and
\code{coef.brr} is a wrapper to \code{\link{brr_estimates}}
}
\examples{
model <- Brr(x=10, y=10, S=100, T=100)
confint(model)
coef(model)
predict(model)
predict(model, Snew=1000, Tnew=1000)
model <- model(Snew=1000, Tnew=1000)
predict(model)
}

