% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardHeader.R, R/aliases.R
\name{bs4DashNavbar}
\alias{bs4DashNavbar}
\alias{dashboardHeader}
\title{Boostrap 4 dashboard navbar}
\usage{
bs4DashNavbar(
  ...,
  title = NULL,
  titleWidth = NULL,
  disable = FALSE,
  .list = NULL,
  leftUi = NULL,
  rightUi = NULL,
  skin = "light",
  status = "white",
  border = TRUE,
  compact = FALSE,
  sidebarIcon = shiny::icon("bars"),
  controlbarIcon = shiny::icon("table-cells"),
  fixed = FALSE
)

dashboardHeader(
  ...,
  title = NULL,
  titleWidth = NULL,
  disable = FALSE,
  .list = NULL,
  leftUi = NULL,
  rightUi = NULL,
  skin = "light",
  status = "white",
  border = TRUE,
  compact = FALSE,
  sidebarIcon = shiny::icon("bars"),
  controlbarIcon = shiny::icon("table-cells"),
  fixed = FALSE
)
}
\arguments{
\item{...}{Any UI element between left and right Ui. Can include \link{navbarMenu} to host
the navigation in the navbar.}

\item{title}{Dashboard title (displayed top-left side). Alternatively, use \link{dashboardBrand}
for more evolved title.}

\item{titleWidth}{This argument is deprecated; bs4Dash (AdminLTE3) title width
is tightly related to the sidebar width, contrary to shinydashboard (AdminLTE2).}

\item{disable}{If \code{TRUE}, don't display the header bar.}

\item{.list}{An optional list containing items to put in the header. Same as
the \code{...} arguments, but in list format. This can be useful when
working with programmatically generated items.}

\item{leftUi}{Custom left Ui content. Any element like \link{dropdownMenu}.}

\item{rightUi}{Custom right Ui content. Any element like \link{dropdownMenu}.}

\item{skin}{Navbar skin. "dark" or "light".}

\item{status}{Navbar status. Valid statuses are defined as follows:
\itemize{
  \item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
  \item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
  \item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
  \item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
  \item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
  \item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
  \item \code{gray-dark}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#343a40")}.
  \item \code{gray}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#adb5bd")}.
  \item \code{white}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#fff")}.
  \item \code{indigo}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6610f2")}.
  \item \code{lightblue}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3c8dbc")}.
  \item \code{navy}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#001f3f")}.
  \item \code{purple}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#605ca8")}.
  \item \code{fuchsia}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#f012be")}.
  \item \code{pink}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#e83e8c")}.
  \item \code{maroon}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#d81b60")}.
  \item \code{orange}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ff851b")}.
  \item \code{lime}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#01ff70")}.
  \item \code{teal}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#39cccc")}.
  \item \code{olive}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3d9970")}.
}}

\item{border}{Whether to separate the navbar and body by a border. TRUE by default.}

\item{compact}{Whether items should be compacted. FALSE by default.}

\item{sidebarIcon}{Icon of the main sidebar toggle.}

\item{controlbarIcon}{Icon to toggle the controlbar (left).}

\item{fixed}{Whether to fix the navbar to the top. FALSE by default.}
}
\description{
\link{dashboardHeader} creates an adminLTE3 dashboard navbar to be included in
\link{dashboardPage}.
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
