% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed_search.R
\name{bs_search_posts}
\alias{bs_search_posts}
\title{Find posts matching search criteria}
\usage{
bs_search_posts(
  query,
  sort = NULL,
  since = NULL,
  until = NULL,
  mentions = NULL,
  author = NULL,
  lang = NULL,
  domain = NULL,
  url = NULL,
  tag = NULL,
  cursor = NULL,
  limit = NULL,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{query}{Character vector, length 1. character. Search query, Lucene query syntax is recommended.}

\item{sort}{character. Order or results. Either \code{'top'} or \code{'latest'}}

\item{since}{character. Filter results for posts on or after the indicated datetime or ISO date (YYYY-MM-DD).}

\item{until}{character. Filter results for posts before the indicated datetime or ISO date (YYYY-MM-DD).}

\item{mentions}{character. Filter to posts which mention the given account.}

\item{author}{character. Filter to posts by the given account.}

\item{lang}{character. Filter to posts in the given language.}

\item{domain}{character. Filter to posts with URLs (facet links or embeds) linking to the given domain (hostname). Server may apply hostname normalization.}

\item{url}{character. Filter to posts with links (facet links or embeds) pointing to this URL. Server may apply URL normalization or fuzzy matching.}

\item{tag}{character. Filter to posts with the given tag (hashtag), based on rich-text facet or tag field. Do not include the hash (#) prefix. Multiple tags can be specified, with 'AND' matching.}

\item{cursor}{Character, length 1. A cursor property from a prior response. Default: \code{NULL}.}

\item{limit}{Integer. Number of records to request. If over \code{100}, multiple requests are made.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of suggested accounts to follow
}
\description{
Find posts matching search criteria
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/feed/searchPosts.json}{feed/searchPosts.json (2024-11-25)}
}

\section{Function introduced}{

\code{v0.1.1} (2023-12-13)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_search_posts('redistricting')
bs_search_posts('ggplot2', tag = 'rstats', sort = 'latest')
\dontshow{\}) # examplesIf}
}
\concept{feed}
