% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEsummaryPanel.R
\name{DEsummaryPanel}
\alias{DEsummaryPanel}
\alias{DEsummaryPanelUI}
\alias{DEsummaryPanelServer}
\title{Generate the DE summary panel of the shiny app}
\usage{
DEsummaryPanelUI(id, metadata, show = TRUE)

DEsummaryPanelServer(id, expression.matrix, metadata, DEresults, anno)
}
\arguments{
\item{id}{the input slot that will be used to access the value}

\item{metadata}{a data frame containing metadata for the samples contained
in the expression.matrix; must contain at minimum two columns:
the first column must contain the column names of the expression.matrix,
while the last column is assumed to contain the experimental conditions
that will be tested for differential expression; a list  (of the same
length as modality) can be provided if #' \code{length(modality) > 1}}

\item{show}{whether to show the panel or not; default is TRUE; there for
compatibility with specifying panels to show}

\item{expression.matrix}{the expression matrix; rows correspond to genes and
columns correspond to samples; usually preprocessed by
\code{\link{preprocessExpressionMatrix}}; a list  (of the same length as
modality) can be provided if #' \code{length(modality) > 1}}

\item{DEresults}{differential expression results output from DEpanelServer;
a reactive list with slots 'DEtable' (all genes), 'DEtableSubset' (only DE genes),
'lfcThreshold' and 'pvalThreshold'}

\item{anno}{annotation data frame containing a match between the row names
of the expression.matrix (usually ENSEMBL IDs) and the gene names that
should be rendered within the app and in output files; this object is
created by \code{\link{generateShinyApp}} using the org.db specified}
}
\value{
The UI and Server components of the shiny module, that can be used
within the UI and Server definitions of a shiny app.
}
\description{
These are the UI and server components of the Heatmap panel of the
shiny app. It is generated by including 'DEsummary' in the panels.default argument
of \code{\link{generateShinyApp}}.
}
