% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R, R/slice_activities.R, R/slice_events.R
\name{slice}
\alias{slice}
\alias{slice.log}
\alias{slice.grouped_log}
\alias{slice_activities.eventlog}
\alias{slice_activities.activitylog}
\alias{slice_activities.grouped_log}
\alias{slice_events.eventlog}
\alias{slice_events.grouped_eventlog}
\title{Slice function for event log}
\usage{
slice(.data, ..., .by = NULL, .preserve = FALSE)

\method{slice}{log}(.data, ...)

\method{slice}{grouped_log}(.data, ...)

\method{slice_activities}{eventlog}(.data, ...)

\method{slice_activities}{activitylog}(.data, ...)

\method{slice_activities}{grouped_log}(.data, ...)

\method{slice_events}{eventlog}(.data, ...)

\method{slice_events}{grouped_eventlog}(.data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{Additional arguments passed to \link[=slice]{dplyr}}

\item{.by}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{.preserve}{Relevant when the \code{.data} input is grouped.
If \code{.preserve = FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise the grouping is kept as is.}
}
\description{
Slice function for event log
}
\section{Methods (by class)}{
\itemize{
\item \code{slice(log)}: Slice n cases of a log

\item \code{slice(grouped_log)}: Slice grouped log: take slice of cases from each group.

}}
\section{Functions}{
\itemize{
\item \code{slice_activities(eventlog)}: Take a slice of activity instances from event log

\item \code{slice_activities(activitylog)}: Take a slice of activity instances from activity log

\item \code{slice_activities(grouped_log)}: Take a slice of activity instances from grouped event log

\item \code{slice_events(eventlog)}: Take a slice of events from event log

\item \code{slice_events(grouped_eventlog)}: Take a slice of events from grouped event log

}}
