% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-forecast.R
\name{forecast_expand}
\alias{forecast_expand}
\title{Out-of-sample Forecasting based on Expanding Window}
\usage{
forecast_expand(object, n_ahead, y_test)
}
\arguments{
\item{object}{Model object}

\item{n_ahead}{Step to forecast in rolling window scheme}

\item{y_test}{Test data to be compared. Use \code{\link[=divide_ts]{divide_ts()}} if you don't have separate evaluation dataset.}
}
\value{
\code{predbvhar_expand} \link{class}
}
\description{
This function conducts expanding window forecasting.
}
\details{
Expanding windows forecasting fixes the starting period.
It moves the window ahead and forecast h-ahead in \code{y_test} set.
}
\references{
Hyndman, R. J., & Athanasopoulos, G. (2021). \emph{Forecasting: Principles and practice} (3rd ed.). OTEXTS. \url{https://otexts.com/fpp3/}
}
\seealso{
See \link{ts_forecasting_cv} for out-of-sample forecasting methods.
}
