% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{cor_igraph}
\alias{cor_igraph}
\title{Make an igraph object}
\usage{
cor_igraph(ob)
}
\arguments{
\item{ob}{A \link{cmicroRNA} or \link{cTF} object such as this returned by
calling \link{cmicroRNA} or \link{cTF}.}
}
\value{
An \code{igraph} object
}
\description{
An \code{igraph} object of from \link{cmicroRNA} or \link{cTF} 
objects.
}
\examples{
# load required libraries
library(RSQLite)
library(cRegulome)

# locate the testset file and connect
fl <- system.file('extdata', 'cRegulome.db', package = 'cRegulome')
conn <- dbConnect(SQLite(), fl)

# enter a custom query with different arguments
dat <- get_mir(conn,
               mir = c('hsa-let-7g', 'hsa-let-7i'),
               study = 'STES')

# make a cmicroRNA object   
cmir <- cmicroRNA(dat)

# print object
cor_igraph(cmir)

}
