% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_clima.R
\name{daily_clima}
\alias{daily_clima}
\title{daily_clima}
\usage{
daily_clima(b, dates = NULL)
}
\arguments{
\item{b}{RasterBrick/Stack containing the historical observations or a proxy
(typically a reanalysis) that is used to derive the climatological
information. This needs to contain daily layers for multiple years.
\code{names(b)} should contain dates for comparison
(e.g. X2017.01.01).}

\item{dates}{Dates for which we need to calculate daily climatology.
By default, this is a leap year.}
}
\value{
The function returns a RasterBrick (if \code{dates} contains one date)
or a list of RasterBricks (if \code{dates} contains more than one date).
Extent, resolution and land-sea mask match those of \code{b}.
Values are the subset of \code{b} related to the given \code{dates}.
}
\description{
This function generates daily climatological maps.
}
\examples{
\dontrun{
  # Generate dummy RasterBrick
  set.seed(0)
  r <- raster(nrows = 2, ncols = 2,
              xmn = 0, xmx = 360, ymn = -90, ymx = 90, vals = 30)
  b <- raster::brick(lapply(1:(365 * 3),
       function(i) raster::setValues(r, runif(n = raster::ncell(r),
                                              min = 0, max = 100))))
  names(b) <- seq.Date(from = as.Date("1993-01-01"),
                       to = as.Date("1995-12-31"),
                       by = "day")
  daily_clima(b, as.Date("1996-01-01"))
}

}
