% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observations.R
\name{observations}
\alias{observations}
\alias{observations<-}
\title{Get or set observations}
\usage{
observations(x)

observations(x) <- value
}
\arguments{
\item{x}{Camera Trap Data Package object, as returned by \code{\link[=read_camtrapdp]{read_camtrapdp()}}.}

\item{value}{A data frame to assign as observations.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} data frame with observations.
}
\description{
\code{observations()} gets the observations from a Camera Trap Data Package
object.

\verb{observations()<-} is the assignment equivalent.
\itemize{
\item It should only be used within other functions, where the expected data
structure can be guaranteed.
\item Metadata (\code{x$taxonomic}) are updated to match the assigned observations.
}
}
\examples{
x <- example_dataset()
# Get the observations
observations(x)

# Set observations (not recommended outside a function)
observations(x) <- head(observations(x), 1)
}
\seealso{
Other accessor functions: 
\code{\link{contributors}()},
\code{\link{deployments}()},
\code{\link{events}()},
\code{\link{individuals}()},
\code{\link{locations}()},
\code{\link{media}()},
\code{\link{taxa}()}
}
\concept{accessor functions}
