% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wds.R
\name{get_statcan_wds_metadata}
\alias{get_statcan_wds_metadata}
\title{Query the StatCan WDS for metadata}
\usage{
get_statcan_wds_metadata(census_year, level, version = NULL, refresh = FALSE)
}
\arguments{
\item{census_year}{census year to get the data for, right now only 2021 is supported}

\item{level}{geographic level to return the data for, valid choices are
"PR","CD","CMACA","CSD","CT","ADA","DA","ER","FED","DPL","POPCNTR", "FSA"}

\item{version}{optionally specify a version of the data to download. For example, for FED level data, version 1.3 will
access the 2013 represenation order, whereas version 2.0 will access the 2023 representation order. By default the latest
available version is accessed.}

\item{refresh}{default is `FALSE` will refresh the temporary cache if `TRUE`}
}
\value{
tibble with the metadata
}
\description{
Get official metadata information from Statistics Canada for a given geographic level. Only available for the 2021 census.
Data is cached for the duration of the R session.
}
\examples{
# get metadata for federal electoral districts
\dontrun{
get_statcan_wds_metadata(census_year="2021",level="FED")
}
}
