% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence_rates_difference.R
\name{incidence_rates_difference}
\alias{incidence_rates_difference}
\title{Compute incidence rates difference}
\usage{
incidence_rates_difference(ncan, py, ncanref, pyref, ncan.min = 5, py.min = 0)
}
\arguments{
\item{ncan}{integer, number of cancers in the population of interest}

\item{py}{integer, person-year of the the population of interest}

\item{ncanref}{integer, number of cancers in the reference population}

\item{pyref}{integer, person-year of the the reference population}

\item{ncan.min}{integer, minimum number of observation required not to mask the CI's out}

\item{py.min}{integer, minimum person-year required not to mask the CI's out

Incidence rates differences and associated 95\% confidence interval are computing assuming normal distribution of the differences..}
}
\value{
a 3 column data.frame containing the incidence rates difference (est) and associated 95\% CI (lci, uci)
}
\description{
Compute incidence rates difference
}
\examples{
ncan <- 1:10
py <- 101:110
ncanref <- 41:50
pyref <- 251:260
ncan.min <- 5

incidence_rates_difference(ncan, py, ncanref, pyref, ncan.min)
}
\concept{summary-stat}
