% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_ind.R
\name{remove_ind}
\alias{remove_ind}
\title{Remove individuals}
\usage{
remove_ind(data_obj, ind_to_remove = NULL, names_to_remove = NULL)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{ind_to_remove}{Indices of individuals to remove}

\item{names_to_remove}{Names of individuals to remove
Only one of ind_to_remove or names_to_remove should be specified.}
}
\value{
an updated cape data object with specified individuals removed.
}
\description{
Remove individuals
}
\examples{
\dontrun{
#remove males
covar_info <- get_covar(data_obj)
male_idx <- which(covar_info$covar_table[,"sex"] == 1)
data_obj <- remove_ind(data_obj, ind_to_remove = male_idx)
}

}
