% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindPosteriorMeanRate.R
\name{FindPosteriorMeanRate}
\alias{FindPosteriorMeanRate}
\title{Find Posterior Mean Rate of Sample Occurrence for Poisson Process Model}
\usage{
FindPosteriorMeanRate(
  output_data,
  calendar_age_sequence,
  n_posterior_samples = 5000,
  interval_width = "2sigma",
  bespoke_probability = NA,
  n_burn = NA,
  n_end = NA
)
}
\arguments{
\item{output_data}{The return value from the updating function
\link{PPcalibrate}. Optionally, the output data can have an extra list item
named \code{label} which is used to set the label on the plot legend.}

\item{calendar_age_sequence}{A vector containing the calendar age grid (in cal yr BP) on which to
calculate the posterior mean rate.}

\item{n_posterior_samples}{Number of samples it will draw, after having removed \code{n_burn},
from the (thinned) MCMC realisations stored in \code{output_data} to estimate the
rate \eqn{\lambda(t)}. These samples may be repeats if the number of, post burn-in,
realisations is less than \code{n_posterior_samples}. If not given, 5000 is used.}

\item{interval_width}{The confidence intervals to show for both the
calibration curve and the predictive density. Choose from one of \code{"1sigma"} (68.3\%),
\code{"2sigma"} (95.4\%) and \code{"bespoke"}. Default is \code{"2sigma"}.}

\item{bespoke_probability}{The probability to use for the confidence interval
if \code{"bespoke"} is chosen above. E.g., if 0.95 is chosen, then the 95\% confidence
interval is calculated. Ignored if \code{"bespoke"} is not chosen.}

\item{n_burn}{The number of MCMC iterations that should be discarded as burn-in (i.e.,
considered to be occurring before the MCMC has converged). This relates to the number
of iterations (\code{n_iter}) when running the original update functions (not the thinned \code{output_data}).
Any MCMC iterations before this are not used in the calculations. If not given, the first half of the
MCMC chain is discarded. Note: The maximum value that the function
will allow is \code{n_iter - 100 * n_thin} (where \code{n_iter} and \code{n_thin} are the arguments that were given to
\link{PPcalibrate}) which would leave only 100 of the (thinned) values in \code{output_data}.}

\item{n_end}{The last iteration in the original MCMC chain to use in the calculations. Assumed to be the
total number of iterations performed, i.e. \code{n_iter}, if not given.}
}
\value{
A list, each item containing a data frame of the \code{calendar_age_BP}, the \code{rate_mean}
and the confidence intervals for the rate - \code{rate_ci_lower} and \code{rate_ci_upper}.
}
\description{
Given output from the Poisson process fitting function \link{PPcalibrate} calculate
the posterior mean rate of sample occurrence (i.e., the underlying Poisson process
rate \eqn{\lambda(t)}) together with specified probability intervals, on a given calendar age
grid (provided in cal yr BP).

\strong{Note:} If you want to calculate and plot the result, use
\link{PlotPosteriorMeanRate} instead.

For more information read the vignette: \cr
\code{vignette("Poisson-process-modelling", package = "carbondate")}
}
\examples{
# NOTE: All these examples are shown with a small n_iter and n_posterior_samples
# to speed up execution.
# Try n_iter and n_posterior_samples as the function defaults.

pp_output <- PPcalibrate(
    pp_uniform_phase$c14_age,
    pp_uniform_phase$c14_sig,
    intcal20,
    n_iter = 1000,
    show_progress = FALSE)

# Default plot with 2 sigma interval
FindPosteriorMeanRate(pp_output, seq(450, 640, length=10), n_posterior_samples = 100)
}
\seealso{
\link{PlotPosteriorMeanRate}
}
