% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear.R
\name{nonlinear_mirror}
\alias{nonlinear_mirror}
\title{Generate Nonlinear Mirror Data with Noise}
\usage{
nonlinear_mirror(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of samples to generate.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the nonlinear mirror data with noise.
}
\description{
This function generates a dataset representing two mirror-image clusters with added noise.
}
\examples{
set.seed(20240412)
nonlinear_mirror <- nonlinear_mirror(
  n = 400, num_noise = 2, min_n = -0.05,
  max_n = 0.05
)
}
