% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_cartogramR.R
\name{geom_cartogramR}
\alias{geom_cartogramR}
\title{Apply the deformation used to build a cartogram to a set of
simple geometry  coordinates}
\usage{
geom_cartogramR(sfgeom, carto, verbose = FALSE)
}
\arguments{
\item{sfgeom}{a sf or a sfc object which contains simple feature geometry of
types in the following \code{POINT}, \code{MULTIPOINT}, \code{LINESTRING},
\code{MULTILINESTRING}, \code{POLYGON}, `MULTIPOLYGON}

\item{carto}{a cartogramR object}

\item{verbose}{a boolean object to set on verbose mode (default to \code{FALSE})}
}
\value{
a sf or a sfc object which contains simple feature geometry transformed
}
\description{
Apply the deformation used to build a cartogram to a set of
simple geometry coordinates. The resulting  simple geometry object can
be used to add geometry features on the cartogram.
}
\examples{
\donttest{
  data(usa)
  carto <- cartogramR(usa, "electors64")
  LA <- sf::st_sfc(sf::st_point(c(-118.243685, 34.052234)))
  sf::st_crs(LA) <- 4326
  moregeom <- geom_cartogramR(LA, carto)
  plot(carto)
  plot(moregeom, add=TRUE, col=2, pch=15)
}

}
