% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/propSymbolsLayer.R
\name{propSymbolsLayer}
\alias{propSymbolsLayer}
\title{Proportional Symbols Layer}
\usage{
propSymbolsLayer(spdf, df, spdfid = NULL, dfid = NULL, var, k = 0.02,
  fixmax = NULL, breakval = NULL, symbols = "circle", col = "#E84923",
  col2 = "#7DC437", border = "black", lwd = 1,
  legend.pos = "bottomleft", legend.title.txt = var,
  legend.title.cex = 0.8, legend.values.cex = 0.6, legend.values.rnd = 0,
  legend.style = "c", legend.frame = FALSE, add = TRUE)
}
\arguments{
\item{spdf}{a SpatialPointsDataFrame or a SpatialPolygonsDataFrame; if spdf
is a SpatialPolygonsDataFrame symbols are plotted on centroids.}

\item{df}{a data frame that contains the values to plot.}

\item{spdfid}{identifier field in spdf, default to the first column
of the spdf data frame. (optional)}

\item{dfid}{identifier field in df, default to the first column
of df. (optional)}

\item{var}{name of the numeric field in df to plot.}

\item{k}{share of the map occupied by the biggest symbol (see Details).}

\item{fixmax}{value of the biggest symbol (see Details).}

\item{breakval}{breaking value (see Details).}

\item{symbols}{type of symbols, one of "circle", "square" or "bar".}

\item{col}{color of symbols.}

\item{col2}{second color of symbols (see Details).}

\item{border}{color of polygon borders.}

\item{lwd}{borders width.}

\item{legend.pos}{position of the legend, one of "topleft", "top",
"topright", "left", "right", "bottomleft", "bottom", "bottomright". If
legend.pos is "n" then the legend is not plotted.}

\item{legend.title.txt}{title of the legend.}

\item{legend.title.cex}{size of the legend title.}

\item{legend.values.cex}{size of the values in the legend.}

\item{legend.values.rnd}{number of decimal places of the values
displayed in the legend.}

\item{legend.style}{either "c" or "e". The legend has two display
styles, "c" stands for compact and "e" for extended.}

\item{legend.frame}{boolean; whether to add a frame to the legend (TRUE) or
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or
not (FALSE).}
}
\description{
Plot a proportional symbols layer.
}
\details{
The breakval parameter allows to plot symbols of two
colors: the first color (col) for values superior or equal to breakval,
second color (col2) for values inferior to breakval.

Two maps with the same spdf, k, and fixmax parameters will be comparable.
}
\examples{
data("nuts2006")
## Example 1
# Layout plot
layoutLayer(title = "Countries Population in Europe",
            sources = "Eurostat, 2008",
            scale = NULL,
            frame = TRUE,
            col = "black",
            coltitle = "white",
            bg = "#D9F5FF",
            south = TRUE,
            extent = nuts0.spdf)
# Countries plot
plot(nuts0.spdf, col = "grey60",border = "grey20", add=TRUE)
# Population plot on proportional symbols
propSymbolsLayer(spdf = nuts0.spdf, df = nuts0.df,
                 var = "pop2008", k = 0.01,
                 symbols = "square", col =  "#920000",
                 legend.pos = "right",
                 legend.title.txt = "Total\\npopulation (2008)",
                 legend.style = "c")

## Example 2
# Countries plot
plot(nuts0.spdf, col = "grey60",border = "grey20")
# Population plot on proportional symbols
propSymbolsLayer(spdf = nuts0.spdf, df = nuts0.df,
                 var = "gdppps2008", k = 0.01,
                 symbols = "bar", col =  "#B00EF0",
                 legend.pos = "right",
                 legend.title.txt = "GDP\\nin Millions PPS (2008)",
                 legend.style = "e")

## Example 3
oldpar <- par(mfrow = c(1,2), mar = c(0,0,0,0))
# Countries plot
plot(nuts0.spdf, col = "grey60",border = "grey20", add=FALSE)
# Population plot on proportional symbols
propSymbolsLayer(spdf = nuts0.spdf, df = nuts0.df,
                 var = "birth_2008", k = 0.01,
                 fixmax = max(nuts0.df$birth_2008),
                 symbols = "circle", col =  "orange",
                 legend.pos = "right",
                 legend.title.txt = "nb of births",
                 legend.style = "e")
plot(nuts0.spdf, col = "grey60",border = "grey20", add=FALSE)
# Population plot on proportional symbols
propSymbolsLayer(spdf = nuts0.spdf, df = nuts0.df,
                 var = "death_2008", k = 0.01,
                 symbols = "circle", col =  "pink",
                 fixmax = max(nuts0.df$birth_2008),
                 legend.pos = "right",
                 legend.style = "e",
                 legend.title.txt = "nb of deaths")
par(oldpar)

## Example 4
nuts0.df$balance <- nuts0.df$birth_2008-nuts0.df$death_2008
plot(nuts0.spdf, col = "grey60",border = "grey20", add=FALSE)
# Population plot on proportional symbols
propSymbolsLayer(spdf = nuts0.spdf, df = nuts0.df,
                 var = "balance", k = 0.01,
                 symbols = "circle",
                 col = "orange", col2 = "green", breakval=0,
                 legend.pos = "right",
                 legend.style = "c",
                 legend.title.txt = "Natural Balance\\n(2008)")
}
\seealso{
\link{legendBarsSymbols}, \link{legendCirclesSymbols},
\link{legendSquaresSymbols}, \link{propSymbolsChoroLayer},
\link{propSymbolsTypoLayer}
}

