% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTiles.R
\name{getTiles}
\alias{getTiles}
\title{Get Tiles from Open Map Servers}
\usage{
getTiles(spdf, type = "osm", zoom = NULL, crop = FALSE)
}
\arguments{
\item{spdf}{a Spatial*DataFrame with a valid projection attribute.}

\item{type}{the tile server from which to get the map, one of "hikebike", 
"hotstyle", "lovinacycle", "lovinahike", "osmgrayscale", "stamenbw" and 
"stamenwatercolor".}

\item{zoom}{the zoom level. If null, it is determined automatically 
(see Details).}

\item{crop}{TRUE if results should be cropped to the specified spdf extent, FALSE otherwise.}
}
\value{
A RatserBrick is returned.
}
\description{
Get map tiles based on a Spatial*DataFrame extent. Maps can be 
fetched from various open map servers.
}
\details{
Zoom levels are descibed on the OpenStreetMap wiki: 
\url{http://wiki.openstreetmap.org/wiki/Zoom_levels}.
}
\note{
This function is a wrapper around the \code{osm.raster} function 
from the \code{rosm} package. \cr
Use directly the \href{https://CRAN.R-project.org/package=rosm}{rosm} package to have a finer control over  
extraction and display parameters.
}
\examples{
\dontrun{
data("nuts2006")
# extract Denmark
spdf <- nuts0.spdf[nuts0.spdf$id=="DK",]   
# Download the tiles, extent = Denmark 
den <- getTiles(spdf = spdf, type = "stamenwatercolor", crop = TRUE)
class(den)
# Plot the tiles
tilesLayer(den)
# Plot countries
plot(spdf, add=TRUE)
# Map tiles sources
mtext(text = "Map tiles by Stamen Design, under CC BY 3.0. Data by OpenStreetMap, under CC BY SA.",
      side = 1, adj = 0, cex = 0.7, font = 3)
}
}
\seealso{
\link{tilesLayer}
}
