% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legends.R
\name{legendCirclesSymbols}
\alias{legendCirclesSymbols}
\title{Legend for Proportional Circles Maps}
\usage{
legendCirclesSymbols(pos = "topleft", title.txt = "Title of the legend",
  title.cex = 0.8, cex = 1, border = "black", lwd = 1,
  values.cex = 0.6, var, inches, col = "#E84923", frame = FALSE,
  values.rnd = 0, style = "c")
}
\arguments{
\item{pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)).}

\item{title.txt}{title of the legend.}

\item{title.cex}{size of the legend title.}

\item{cex}{size of the legend. 2 means two times bigger.}

\item{border}{color of the borders.}

\item{lwd}{width of the borders.}

\item{values.cex}{size of the values in the legend.}

\item{var}{vector of values (at least min and max).}

\item{inches}{radii of the biggest circle.}

\item{col}{color of symbols.}

\item{frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{values.rnd}{number of decimal places of the values in 
the legend.}

\item{style}{either "c" or "e". The legend has two display 
styles, "c" stands for compact and "e" for extended.}
}
\description{
Plot legend for proportional circles maps
}
\examples{
library(sp) 
data("nuts2006")
plot(nuts0.spdf)
propSymbolsLayer(spdf = nuts0.spdf, df = nuts0.df, var = "pop2008", 
                 inches = 0.2, legend.pos = "n")

legendCirclesSymbols(pos = "topleft", inches = 0.2,
                     var = c(min(nuts0.df$pop2008), max(nuts0.df$pop2008)))

legendCirclesSymbols(pos = "left", 
                     var = c(min(nuts0.df$pop2008), max(nuts0.df$pop2008)),
                     inches = 0.2, style = "e")
oopt <- options(scipen = 10)
legendCirclesSymbols(pos = "bottomleft", 
                     var = c(35e3, 1e7, 4e7, max(nuts0.df$pop2008)),
                     inches = 0.2, style = "c")
legendCirclesSymbols(pos = "topright", cex = 2,
                     var = c(35e3,1e6, 5e6, 1e7, 2e7, 4e7, 6e7,max(nuts0.df$pop2008)),
                     inches = 0.2, style = "e", frame = TRUE)
options(oopt)

legendCirclesSymbols(pos = c(5533388, 1570417),
                     var = c(min(nuts0.df$pop2008),max(nuts0.df$pop2008)),
                     inches = 0.2, frame = TRUE)
}
