% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat2cat_agg.R
\name{cat2cat_agg}
\alias{cat2cat_agg}
\title{Aggregate panel dataset - Manual mapping of a categorical variable according to a new encoding}
\usage{
cat2cat_agg(
  data = list(old = NULL, new = NULL, cat_var = NULL, time_var = NULL, freq_var = NULL),
  ...
)
}
\arguments{
\item{data}{list with 5 named fields `old` `new` `cat_var` `time_var` `freq_var`}

\item{...}{equations}
}
\value{
list of data.frame objects
}
\description{
Aggregate dataset - Manual mapping of a categorical variable according to a new encoding where user supplying transitions by equations.
}
\details{
data args
\itemize{
 \item{"old"}{ data.frame older time point in the panel}
 \item{"new"} { data.frame more recent time point in the panel}
 \item{"cat_var"}{ character name of the categorical variable}
 \item{"time_var"}{ character name of time variable}
 \item{"freq_var"}{ character name of frequency variable}
}
... equations where direction is set by ">","<","%>%","%<%"
}
\examples{
data(verticals)
agg_old <- verticals[verticals$v_date == "2020-04-01", ]
agg_new <- verticals[verticals$v_date == "2020-05-01", ]

## cat2cat_man - could map in both directions at once although
## usually we want to have oold or new representation

agg = cat2cat_agg(data = list(old = agg_old,
                             new = agg_new,
                             cat_var = "vertical",
                             time_var = "v_date",
                             freq_var = "counts"),
                 Automotive \%<\% c(Automotive1, Automotive2),
                 c(Kids1, Kids2) \%>\% c(Kids),
                 Home \%>\% c(Home, Supermarket))
}
