% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfa.R
\name{Diff.lige}
\alias{Diff.lige}
\title{Diff.lige}
\usage{
Diff.lige(cfaobj1, cfaobj2, se = T, h)
}
\arguments{
\item{cfaobj1}{the first CFA object}

\item{cfaobj2}{the second CFA object}

\item{se}{boolean whether or not to compute standard errors}

\item{h}{a bandwidth}
}
\value{
a CFASE object
}
\description{
compute the difference between two estimates of the LIGE
}
\examples{
\dontrun{
data(igm)
tvals <- seq(10,12,length.out=8)
yvals <- seq(quantile(igm$lcfincome, .05), quantile(igm$lcfincome, .95), length.out=50)

## obtain counterfactual results
out <- cfa2(lcfincome ~ lfincome, tvals, yvals, igm, method1="qr",
xformla2=~HEDUC, method2="qr", iters=10, tau1=seq(.05,.95,.05),
tau2=seq(.05,.95,.05))
Diff.lige(out$cfa1, out$cfa2, h=0.5)
}

}
