% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowsColumns.R
\name{moveValuesToColumns}
\alias{moveValuesToColumns}
\title{Move values from rows to columns (wrapper for \code{\link[tidyr]{spread}} or pivot).}
\usage{
moveValuesToColumns(data, columnToTakeKeysFrom, columnToTakeValuesFrom,
  rowKeyColumns, ..., fill = NA, convert = FALSE, drop = TRUE,
  sep = NULL)
}
\arguments{
\item{data}{data.frame to work with.}

\item{columnToTakeKeysFrom}{character name of column build new column names from.}

\item{columnToTakeValuesFrom}{character name of column to get values from.}

\item{rowKeyColumns}{character array names columns that should be table keys.}

\item{...}{force later arguments to bind by name.}

\item{fill}{passed to \code{\link[tidyr]{spread}}}

\item{convert}{passed to \code{\link[tidyr]{spread}}}

\item{drop}{passed to \code{\link[tidyr]{spread}}}

\item{sep}{passed to \code{\link[tidyr]{spread}}}
}
\value{
new data.frame with values moved to columns.
}
\description{
For a tutorial please try \code{vignette('RowsAndColumns', package='cdata')}.
}
\examples{

d <- data.frame(meas= c('AUC', 'R2'), val= c(0.6, 0.2))
moveValuesToColumns(d,
                    columnToTakeKeysFrom= 'meas',
                    columnToTakeValuesFrom= 'val',
                    rowKeyColumns= c())

}
\seealso{
\code{\link{moveValuesToRows}}
}
