% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowsColsQ.R
\name{buildPivotControlTableN}
\alias{buildPivotControlTableN}
\title{Build a moveValuesToColumns*() control table that specifies a pivot.}
\usage{
buildPivotControlTableN(tableName, columnToTakeKeysFrom, columnToTakeValuesFrom,
  my_db, ..., prefix = columnToTakeKeysFrom, sep = NULL)
}
\arguments{
\item{tableName}{Name of table to scan for new column names.}

\item{columnToTakeKeysFrom}{character name of column build new column names from.}

\item{columnToTakeValuesFrom}{character name of column to get values from.}

\item{my_db}{db handle}

\item{...}{not used, force later args to be by name}

\item{prefix}{column name prefix (only used when sep is not NULL)}

\item{sep}{separator to build complex column names.}
}
\value{
control table
}
\description{
Some discussion and examples can be found here: \url{https://winvector.github.io/replyr/articles/FluidData.html}.
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
d <- data.frame(measType = c("wt", "ht"),
                measValue = c(150, 6),
                stringsAsFactors = FALSE)
DBI::dbWriteTable(my_db,
                  'd',
                  d,
                  overwrite = TRUE,
                  temporary = TRUE)
buildPivotControlTableN('d', 'measType', 'measValue',
                                 my_db = my_db,
                                 sep = '_')

}
\seealso{
\code{\link{moveValuesToColumnsN}}
}
