% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ilinet.r
\name{ilinet}
\alias{ilinet}
\title{Retrieve ILINet Surveillance Data}
\usage{
ilinet(region = c("national", "hhs", "census", "state"), years = NULL)
}
\arguments{
\item{region}{one of "\code{national}", "\code{hhs}", "\code{census}", or "\code{state}"}

\item{years}{a vector of years to retrieve data for (i.e. \code{2014} for CDC
flu season 2014-2015). CDC has data for this API going back to 1997.
Default value (\code{NULL}) means retrieve \strong{all} years. NOTE: if you
happen to specify a 2-digit season value (i.e. \code{57} == 2017-2018)
the function is smart enough to retrieve by season ID vs convert that
to a year.}
}
\description{
The CDC FluView Portal provides in-season and past seasons' national, regional,
and state-level outpatient illness and viral surveillance data from both
ILINet (Influenza-like Illness Surveillance Network) and WHO/NREVSS
(National Respiratory and Enteric Virus Surveillance System).
}
\details{
This function retrieves current and historical ILINet surveillance data for
the identified region.
}
\examples{
national_ili <- ilinet("national", years = 2017)
\dontrun{
hhs_ili <- ilinet("hhs")
census_ili <- ilinet("census")
state_ili <- ilinet("state")

all_ili <- suppressWarnings(
  suppressMessages(purrr::map_df(c("national", "hhs", "census", "state"), ilinet)))
}
}
\references{
\itemize{
\item \href{https://gis.cdc.gov/grasp/fluview/fluportaldashboard.html}{CDC FluView Portal}
\item \href{https://wwwn.cdc.gov/ilinet/}{ILINet Portal} (Login required)
\item \href{https://www.cdc.gov/surveillance/nrevss/index.html}{WHO/NREVSS}
}
}
