% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotorUnequal.R
\name{rotorUnequal}
\alias{rotorUnequal}
\title{Balance Tubes of Unequal Mass}
\usage{
rotorUnequal(n, mass = NULL)
}
\arguments{
\item{n}{an integer, the number of rotor buckets.}

\item{mass}{a numeric vector with optional \code{names} attribute, the masses
(and optional names) of tubes.}
}
\value{
\code{rotorUnequal} returns a data frame with three columns:
  \item{\code{initial}}{a vector containing the initial masses of tubes.}
  \item{\code{required}}{a vector containing the required masses of tubes.}
  \item{\code{position}}{a vector containing the bucket positions of tubes.}
  \code{rotorUnequal} also plots a schematic diagram of the centrifuge rotor.
}
\description{
\code{rotorUnequal} returns the required masses and the positions of tubes of
unequal initial mass.
}
\details{
The number of rotor buckets \code{n} ranges from \code{4} to
  \code{48}. The number of tubes (i.e. \code{length(mass)}) should not be
  greater than the number of rotor buckets \code{n}. \cr \cr If \code{mass}
  is not specified, the names and the masses of tubes must then be taken from
  the keyboard. In case \code{mass} has no \code{names} attribute, tubes will
  be named automatically (i.e. \code{S1, S2, S3, } etc.).
}
\examples{
# Input the names and the masses of tubes from the keyboard
rotorUnequal(30)
liver
10.05
gill
9.68
muscle
9.88

# Prepare the masses of tubes before calling the function
samples <- round(rnorm(19, mean = 10, sd = 0.5), 2)
rotorUnequal(30, samples)

# Prepare the masses and the names of tubes before calling the function
small.samples <- c(10.05, 9.68, 9.88)
names(small.samples) <- c("liver", "gill", "muscle")
rotorUnequal(30, small.samples)
}
\references{
Sivek G. On vanishing sums of distinct roots of unity. Integers.
  2010;10(3):365-8. \cr \cr Peil O, Hauryliuk V. A new spin on spinning your
  samples: balancing rotors in a non-trivial manner. arXiv preprint
  arXiv:1004.3671. 2010 Apr 21.
}
\seealso{
\code{\link{rotorCheck}} for checking centrifuge rotors and
  \code{\link{rotorEqual}} for balancing tubes of equal mass.
}
