% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotorVerify.R
\name{rotorVerify}
\alias{rotorVerify}
\title{Verify Centrifuge Balance}
\usage{
rotorVerify(n, pos)
}
\arguments{
\item{n}{an integer, the number of rotor buckets.}

\item{pos}{an integer vector, the positions of tubes.}
}
\value{
\code{rotorVerify} returns \code{1} if the rotor is balanced and
  \code{0} if the rotor is unbalanced.
}
\description{
\code{rotorVerify} checks whether the rotor is balanced given the positions
of tubes of equal mass.
}
\details{
The number of rotor buckets \code{n} ranges from \code{4} to
  \code{48}. The positions of tubes \code{pos} ranges from 1 to \code{n}.
}
\examples{
rotorVerify(30, c(10, 20, 30))
rotorVerify(30, c(1, 11, 21, 4, 28))

}
\references{
Johnsson M. Balancing a centrifuge. R-bloggers. 2016. Available
  from: \url{https://www.r-bloggers.com/2016/06/balancing-a-centrifuge/}.
}
\seealso{
\code{\link{rotorCheck}} for checking centrifuge rotors.
}
