% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotor.R
\name{rotor}
\alias{rotor}
\title{Balance Tubes Using Higher-Order Symmetrical Configurations}
\usage{
rotor(n, k = NULL, seed = 1, elapse = 1)
}
\arguments{
\item{n}{an integer, the number of rotor holes.}

\item{k}{an integer, the number of tubes (optional).}

\item{seed}{an integer, the seed for random number generation. Setting a seed
ensures the reproducibility of the result. See \code{\link{set.seed}} for
more details.}

\item{elapse}{an integer, the constrained time in seconds for random sampling.}
}
\value{
\code{rotor} returns a list with two components:
  \item{\code{check}}{a list with three components:
  \describe{\item{\code{n}}{the number of rotor holes.}
  \item{\code{valid}}{a vector containing the numbers of tubes that can be
  loaded.}
  \item{\code{invalid}}{a vector containing the numbers of tubes that cannot be
  loaded.}}
  } \item{\code{load}}{a list with three components:
  \describe{
  \item{\code{k}}{the number of tubes.}
  \item{\code{decompose}}{a data frame showing different ways to decompose \code{k}.}
  \item{\code{hole}}{a data frame showing hole positions to load tubes.}
  \item{\code{visual}}{a list of rotor images showing hole positions to load tubes.}
  }
  }
}
\description{
\code{rotor} returns the numbers of tubes that can and cannot be loaded
in a centrifuge rotor and optionally shows various ways to balance a certain
number of tubes.
}
\details{
The number of rotor holes \code{n} ranges from \code{4} to
  \code{48}.
}
\examples{
rotor(30, 7)

}
\references{
Sivek G. On vanishing sums of distinct roots of unity. Integers.
  2010;10(3):365-8. \cr \cr Peil O, Hauryliuk V. A new spin on spinning your
  samples: balancing rotors in a non-trivial manner. arXiv preprint
  arXiv:1004.3671. 2010 Apr 21.
}
\seealso{
\code{\link{rotorVerify}} for verifying the balance of pre-existing
  tube configurations.
}
