% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_interactive_what_if.R
\name{plot_interactive}
\alias{plot_interactive}
\alias{plot_interactive.what_if_explainer}
\alias{plot_interactive}
\alias{plot_interactive}
\alias{plot_interactive.default}
\title{Plots Interactive What-If Explanations}
\usage{
\method{plot_interactive}{what_if_explainer}(x, ..., split = "models",
  color = "variables")

plot_interactive(x, ...)

\method{plot_interactive}{default}(x, ..., split = "models",
  color = "variables")
}
\arguments{
\item{x}{a ceteris_paribus explainer produced with the 'ceteris_paribus' function}

\item{...}{other explainers that shall be plotted together}

\item{split}{a character, either 'models' or 'variables'. Sets the variable for faceting}

\item{color}{a character, either 'models' or 'variables'. Sets the variable for coloring}
}
\value{
a ggiraph object
}
\description{
Function 'plot_interactive.what_if_explainer' plots Ceteris Paribus Plots for a single prediction.
}
\examples{
library("DALEX")
 \dontrun{
library("ggiraph")
library("randomForest")
set.seed(59)

apartments_rf_model <- randomForest(m2.price ~ construction.year + surface + floor +
      no.rooms + district, data = apartments)

explainer_rf <- explain(apartments_rf_model,
      data = apartmentsTest[,2:6], y = apartmentsTest$m2.price)

new_apartment <- apartmentsTest[1, ]
new_apartment

wi_rf <- what_if(explainer_rf, observation = new_apartment)
wi_rf

plot_interactive(wi_rf, split = "variables", color = "variables")
}
}
