% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/company-provider.R
\docType{data}
\name{CompanyProvider}
\alias{CompanyProvider}
\alias{company_provider_locales}
\title{CompanyProvider}
\format{An object of class \code{character} of length 9.}
\usage{
company_provider_locales
}
\arguments{
\item{locale}{(character) the locale to use. options: en_US (default),
bg_bg, cs_cz, de_de, es_es, es_mx, fa_ir, fr_fr, hr_hr, it_it}
}
\description{
CompanyProvider
}
\details{
\strong{Methods}
  \describe{
   \item{\code{company}}{
     a company name
   }
   \item{\code{company_prefix}}{
     a company prefix
   }
   \item{\code{company_suffix}}{
     a company suffix
   }
   \item{\code{bs}}{
     bs
   }
   \item{\code{catch_phrase}}{
     a catch phrase
   }
   \item{\code{siren}}{
     a siren
   }
 }
}
\examples{
x <- CompanyProvider$new()
x$locale
x$company()
x$company_suffix()
x$catch_phrase()
x$bs()

x <- CompanyProvider$new(locale = "fr_FR")
x$locale
x$company()
x$company_suffix()
x$siren()

x <- CompanyProvider$new(locale = "hr_HR")
x$locale
x$company()
x$company_suffix()

x <- CompanyProvider$new(locale = "it_IT")
x$locale
x$company()
x$company_suffix()
x$bs()

CompanyProvider$new(locale = "es_MX")$bs()
CompanyProvider$new(locale = "es_MX")$company_prefix()
CompanyProvider$new(locale = "es_MX")$catch_phrase()

CompanyProvider$new(locale = "bg_BG")$company()
CompanyProvider$new(locale = "cs_CZ")$company()
CompanyProvider$new(locale = "de_DE")$company()
CompanyProvider$new(locale = "fa_IR")$company()
}
\keyword{datasets}
\keyword{internal}
