% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemoDivPlot.R
\name{chemoDivPlot}
\alias{chemoDivPlot}
\title{Plot chemodiversity}
\usage{
chemoDivPlot(
  compDisMat = NULL,
  divData = NULL,
  divProfData = NULL,
  sampDisMat = NULL,
  groupData = NULL
)
}
\arguments{
\item{compDisMat}{Compound dissimilarity matrix, generated by
the \code{\link{compDis}} function. Note that only a single matrix
should be supplied, and not the whole list.}

\item{divData}{Diversity/evenness data frame,
generated by the \code{\link{calcDiv}} function. This data frame can
contain a single or multiple columns with diversity/evenness measures.}

\item{divProfData}{Diversity profile, generated by
the \code{\link{calcDivProf}} function. Note that the whole list
outputted by the \code{\link{calcDivProf}} function should be supplied.}

\item{sampDisMat}{Sample dissimilarity matrix, generated by
the \code{\link{sampDis}} function. This can be either the list of one or
both matrices outputted by the function, or a single matrix directly.}

\item{groupData}{Grouping data. Should be either a vector or a data frame
with a single column.}
}
\value{
The specified chemodiversity plots.
}
\description{
Function to conveniently create basic plots of the different types of
chemodiversity measurements calculated by functions in the package.
}
\details{
The function can create four different types of plots,
(using \code{\link[ggplot2]{ggplot2}}) depending on which input data
is supplied:
\itemize{
\item Function argument \code{compDisMat}. A compound dissimilarity matrix
will be plotted as a dendrogram visualizing how
structurally/biosynthetically similar different compounds are to each other.
\item Function argument \code{divData}. Diversity/evenness values will
be plotted as a boxplot.
\item Function argument \code{divProfData}. A diversity profile, plotting
(Functional) Hill diversity at different values of q will be plotted
as a line plot.
\item Function argument \code{sampDisMat}. A sample dissimilarity matrix
will be plotted as an NMDS plot.
\item Function argument \code{groupData}. Grouping data (e.g. population,
species etc.) may be supplied, to plot each group in different
boxes/lines/colours.
}
Note that this function can take any combination of the four arguments
as input, and argument names should always be specified to ensure
each dataset is correctly plotted. If including the function
argument \code{sampDisMat}, a Nonmetric Multidimensional Scaling (NMDS)
will be performed, which may take time for larger datasets.
}
\examples{
minimalDiv <- calcDiv(minimalSampData, minimalCompDis, type = "FuncHillDiv")
groups <- c("A", "A", "B", "B")
chemoDivPlot(divData = minimalDiv, groupData = groups)

data(alpinaCompDis)
data(alpinaSampDis)
data(alpinaPopData)
alpinaDiv <- calcDiv(sampleData = alpinaSampData, compDisMat = alpinaCompDis,
type = "FuncHillDiv")
alpinaDivProf <- calcDivProf(sampleData = alpinaSampData,
compDisMat = alpinaCompDis, type = "FuncHillDiv",
qMin = 0, qMax = 2, step = 0.2)
chemoDivPlot(compDisMat = alpinaCompDis, divData = alpinaDiv,
divProfData = alpinaDivProf, sampDisMat = alpinaSampDis,
groupData = alpinaPopData)
}
