% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/childesr.R
\name{get_types}
\alias{get_types}
\title{Get types}
\usage{
get_types(collection = NULL, language = NULL, corpus = NULL,
  role = NULL, role_exclude = NULL, age = NULL, sex = NULL,
  target_child = NULL, type = NULL, connection = NULL,
  db_version = "current", db_args = NULL)
}
\arguments{
\item{collection}{A character vector of one or more names of collections}

\item{language}{A character vector of one or more languages}

\item{corpus}{A character vector of one or more names of corpora}

\item{role}{A character vector of one or more roles to include}

\item{role_exclude}{A character vector of one or more roles to exclude}

\item{age}{A numeric vector of an age or a min age (inclusive) and max age
(exclusive) in months}

\item{sex}{A character vector of values "male" and/or "female"}

\item{target_child}{A character vector of one or more names of children}

\item{type}{A character vector of one or more type patterns (`%` matches any
number of wildcard characters, `_` matches exactly one wildcard character)}

\item{connection}{A connection to the CHILDES database}

\item{db_version}{String of the name of database version to use}

\item{db_args}{List with host, user, and password defined}
}
\value{
A `tbl` of Type data, filtered down by supplied arguments. If
  `connection` is supplied, the result remains a remote query, otherwise it
  is retrieved into a local tibble.
}
\description{
Get types
}
\examples{
\donttest{
get_types()
}
}
