% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streetNameLocator.R
\name{streetNameLocator}
\alias{streetNameLocator}
\title{Locate road by name.}
\usage{
streetNameLocator(road.name, zoom = FALSE, radius = 0.1,
  cases = "anchors", add.title = TRUE, add.pump = TRUE, vestry = FALSE,
  highlight = TRUE, unit = "meter")
}
\arguments{
\item{road.name}{Character vector. Note that \code{streetNameLocator}() tries to correct for case and to remove extra spaces.}

\item{zoom}{Logical.}

\item{radius}{Numeric. Controls the degree of zoom.}

\item{cases}{Character. Plot cases: NULL, "anchors" or "all".}

\item{add.title}{Logical. Include title.}

\item{add.pump}{Logical. Include nearby pumps.}

\item{vestry}{Logical. TRUE uses the 14 pumps from the Vestry Report. FALSE uses the 13 in the original map.}

\item{highlight}{Logical. Highlight selected road.}

\item{unit}{Character. Unit of measurement: "meter" or "yard". NULL returns the map's native scale.}
}
\value{
A base R graphics plot.
}
\description{
Highlight a road and its cases. See the list of road names in \code{vignette}("road.names").
}
\examples{
streetNameLocator("Oxford Street")
streetNameLocator("oxford street")
streetNameLocator("Cambridge Street", zoom = TRUE)
streetNameLocator("Cambridge Street", zoom = TRUE, radius = 0)
}
\seealso{
\code{\link{roads}}, \code{\link{road.segments}}, \code{\link{streetNumberLocator}}, \code{vignette("road.names")}
}
