% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmasneon2014.R
\name{xmasneon2014}
\alias{xmasneon2014}
\title{Neon Christmas card.}
\usage{
xmasneon2014(
  language = c("english", "spanish", "catalan"),
  nflash = 30,
  pause = 0.1,
  seed = NULL
)
}
\arguments{
\item{language}{Language to be used in the card. One of \code{c("english",
"spanish", "catalan")}. Default is \code{"english"}.}

\item{nflash}{Number of flashes shown in the neon sign. Default is 30.}

\item{pause}{Pause, in seconds, between two consecutive flashes shown in the
neon sign. Default is 0.1.}

\item{seed}{Seed for reproducibility of the card. Default is \code{NULL} (no
seed).}
}
\value{
A Christmas card plot including a message and then a simulations of a
  neon sign.
}
\description{
Christmas card using a neon sign. It only works for wishing 2014.
}
\examples{
\donttest{
xmasneon2014()
xmasneon2014(language = "catalan", nflash = 10, pause = 0.3)
xmasneon2014(language = "spanish", nflash = 8, pause = 1)
xmasneon2014(nflash = 100, pause = 0.02)
}
}
\author{
Jose Barrera-Gomez.
}
