% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ci_glm.R
\name{add_ci.glm}
\alias{add_ci.glm}
\title{Confidence Intervals for Generalized Linear Model Predictions}
\usage{
\method{add_ci}{glm}(tb, fit, alpha = 0.05, names = NULL,
  yhatName = "pred", response = TRUE, type = "parametric",
  nSims = 2000, ...)
}
\arguments{
\item{tb}{A tibble or data frame of new data.}

\item{fit}{An object of class \code{glm}.}

\item{alpha}{A real number between 0 and 1. Controls the confidence
level of the interval estimates.}

\item{names}{\code{NULL} or character vector of length two. If
\code{NULL}, confidence bounds automatically will be named by
\code{add_ci}, otherwise, the lower confidence bound will be
named \code{names[1]} and the upper confidence bound will be
named \code{names[2]}.}

\item{yhatName}{A character vector of length one. Name of the
vector of predictions made for each observation in tb}

\item{response}{A logical. The default is \code{TRUE}. If
\code{TRUE}, the confidence intervals will be determined for
the expected response; if \code{FALSE}, confidence intervals
will be made on the scale of the linear predictor.}

\item{type}{A character vector of length one. Must be \code{type =
"parametric"} or \code{type = "boot"}. \code{type} determines
the method used to compute the confidence intervals.}

\item{nSims}{An integer. Number of simulations to perform if the
bootstrap method is used.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted values, upper and lower
    confidence bounds attached.
}
\description{
This function is one of the methods for \code{add_ci}, and is
called automatically when \code{add_ci} is used on a \code{fit} of
class \code{glm}. The default method calculates confidence
intervals by making an interval on the scale of the linear
predictor, then applying the inverse link function from the model
fit to transform the linear level confidence intervals to the
response level. Alternatively, confidence intervals may be
calculated through a nonparametric bootstrap method.
}
\examples{
# Poisson regression
fit <- glm(dist ~ speed, data = cars, family = "poisson")
add_ci(cars, fit)
# Try a different confidence level
add_ci(cars, fit, alpha = 0.5)
# Add custom names to the confidence bounds (may be useful for plotting)
add_ci(cars, fit, alpha = 0.5, names = c("lwr", "upr"))

# Logistic regression
fit2 <- glm(I(dist > 30) ~ speed, data = cars, family = "binomial")
dat <- cbind(cars, I(cars$dist > 30))
# Form 95\% confidence intervals for the fit:
add_ci(dat, fit2)
# Form 50\% confidence intervals for the fit:
add_ci(dat, fit2, alpha = 0.5)
# Make confidence intervals on the scale of the linear predictor
add_ci(dat, fit2, alpha = 0.5, response = FALSE)
# Add custom names to the confidence bounds
add_ci(dat, fit2, alpha = 0.5, names = c("lwr", "upr"))


}
\seealso{
\code{\link{add_pi.glm}} for prediction intervals for
    \code{glm} objects, \code{\link{add_probs.glm}} for conditional
    probabilities of \code{glm} objects, and
    \code{\link{add_quantile.glm}} for response quantiles of
    \code{glm} objects.
}
