% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{list_projects}
\alias{list_projects}
\title{List Circle CI Projects}
\usage{
list_projects(repo = github_info()$name, user = github_info()$owner$login)
}
\arguments{
\item{repo}{\verb{[character]}\cr
The repository slug to use. Must follow the "\code{user/repo}" structure.}

\item{user}{\verb{[character]}\cr
The username for the repository. By default queried using \code{get_user()}.}
}
\value{
An object of class \code{circle_api} with the following elements
\itemize{
\item \code{content} (queried content)
\item \code{path} (API request)
\item \code{response} (HTTP response information)
}
}
\description{
Retrieve a list of Circle CI repositories for the authenticated
user.
}
\details{
Retrieves a very detailed list of repository and repo-related
information for all Circle CI repository attached to the current user.

This endpoint uses API v1.1 and will probably be removed in the near
future.
}
\examples{
\dontrun{
list_projects()
}
}
\seealso{
\code{\link[=get_pipelines]{get_pipelines()}}, \code{\link[=get_workflows]{get_workflows()}}, \code{\link[=get_jobs]{get_jobs()}}
}
