% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{enhancements_post_geocode}
\alias{enhancements_post_geocode}
\title{Create a Geocode Enhancement}
\usage{
enhancements_post_geocode(
  name,
  remote_host_id,
  credential_id,
  source_schema_and_table,
  schedule = NULL,
  parent_id = NULL,
  notifications = NULL,
  multipart_key = NULL,
  limiting_sql = NULL,
  target_schema = NULL,
  target_table = NULL,
  country = NULL,
  provider = NULL,
  output_address = NULL
)
}
\arguments{
\item{name}{string required. The name of the enhancement job.}

\item{remote_host_id}{integer required. The ID of the remote host.}

\item{credential_id}{integer required. The ID of the remote host credential.}

\item{source_schema_and_table}{string required. The source database schema and table.}

\item{schedule}{list optional. A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday.
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour.
}}

\item{parent_id}{integer optional. Parent ID that triggers this enhancement.}

\item{notifications}{list optional. A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on.
\item failureOn boolean, If failure email notifications are on.
}}

\item{multipart_key}{array optional. The source table primary key.}

\item{limiting_sql}{string optional. The limiting SQL for the source table. "WHERE" should be omitted (e.g. state='IL').}

\item{target_schema}{string optional. The output table schema.}

\item{target_table}{string optional. The output table name.}

\item{country}{string optional. The country of the addresses to be geocoded; either 'us' or 'ca'.}

\item{provider}{string optional. The geocoding provider; one of postgis, nominatim, and geocoder_ca.}

\item{output_address}{boolean optional. Whether to output the parsed address. Only guaranteed for the 'postgis' provider.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for the enhancement.}
\item{name}{string, The name of the enhancement job.}
\item{type}{string, The type of the enhancement (e.g CASS-NCOA)}
\item{createdAt}{string, The time this enhancement was created.}
\item{updatedAt}{string, The time the enhancement was last updated.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{state}{string, The status of the enhancement's last run}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday.
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour.
}}
\item{parentId}{integer, Parent ID that triggers this enhancement.}
\item{notifications}{list, A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on.
\item failureOn boolean, If failure email notifications are on.
}}
\item{runningAs}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{remoteHostId}{integer, The ID of the remote host.}
\item{credentialId}{integer, The ID of the remote host credential.}
\item{sourceSchemaAndTable}{string, The source database schema and table.}
\item{multipartKey}{array, The source table primary key.}
\item{limitingSQL}{string, The limiting SQL for the source table. "WHERE" should be omitted (e.g. state='IL').}
\item{targetSchema}{string, The output table schema.}
\item{targetTable}{string, The output table name.}
\item{country}{string, The country of the addresses to be geocoded; either 'us' or 'ca'.}
\item{provider}{string, The geocoding provider; one of postgis, nominatim, and geocoder_ca.}
\item{outputAddress}{boolean, Whether to output the parsed address. Only guaranteed for the 'postgis' provider.}
\item{archived}{string, The archival status of the requested item(s).}
}
\description{
Create a Geocode Enhancement
}
